%define pkgversion 1.0.2.0
################################################################################
#
# Driver for Xilinx network controllers and boards
# Copyright 2021 Xilinx Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
################################################################################

%{!?dist: %{expand: %%define disttag %%(. %%{_topdir}/SOURCES/auxiliary-disttag; echo -n $(auxiliary_disttag))}}
%{!?kernel:  %{expand: %%define kernel %%(uname -r)}}
%{!?kpath: %{expand: %%define kpath /lib/modules/%%{kernel}/build}}
%{!?auxpath: %{expand: %%define auxpath /sys/bus/auxiliary}}

#%{?auxiliary_minimal: %{expand: %%define auxiliary_config CONFIG_XILINX_DEBUGFS= }}

%define redhat     %(! [ "%{_vendor}" = "redhat" ] ; echo $?)

Name:           auxiliary
Version:        %{pkgversion}
Release:        1
Epoch:          0

Summary:        Xilinx auxiliary device driver

Group:          System Environment/Kernel
License:        GPLv2
URL:		http://www.xilinx.com/
Vendor:		Xilinx Inc

Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-disttag

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  binutils, gcc, make

%description
The Auxiliary driver originally copied from linux source.

This builds a single RPM for a specific kernel version on any
supported Linux distribution.

%define binary_name kernel-module-%{name}-%{dist}-%{kernel}

%package -n %{binary_name}
Summary:        %{summary}
Group:          %{group}
Provides:       %{name}-kmod-symvers = %{kernel}

%description -n %{binary_name}
The Auxiliary driver originally copied frim linux source.

# Inhibit debuginfo package
%define debug_package %{nil}

# -----------------------------------------------------------------------------

%prep
%setup -q

# -----------------------------------------------------------------------------

%build

[ -d "%{kpath}" ] || {
  set +x
  echo >&2 "ERROR: Kernel headers not found.  They should be at:"
  echo >&2 "ERROR:   %{kpath}"
%if %{redhat}
  echo >&2 "Hint: Install the $(echo '%{kernel}' | sed -r 's/(.*)(smp|hugemem|largesmp|PAE|xen)$/kernel-\2-devel-\1/; t; s/^/kernel-devel-/') package"
%endif
  exit 1
}

[ -d "%{auxpath}" ] && {
  set +x
  echo >&2 "ERROR: Auxiliary bus driver is already present or Running kernel has inbuilt support for Auxiliary bus driver "
  echo >&2 "ERROR: If you are trying to upgrade, please remove earlier version and retry."
  exit 1
}
cd $RPM_BUILD_DIR/%{name}-%{version}

# do the build
%{__make} -C aux_pak -j4 KVER=%{kernel} KPATH="%{kpath}" modules

# -----------------------------------------------------------------------------

%install

cd "$RPM_BUILD_DIR/%{name}-%{version}"

# do the install
%{__make} -C aux_pak INSTALL_MOD_PATH="${RPM_BUILD_ROOT}" INSTALL_MOD_DIR="updates" \
  KVER=%{kernel} KPATH="%{kpath}" modules_install
%{__install} -m 0644 aux_pak/drivers/base/Module.symvers \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/updates/auxiliary.symvers
mkdir -p ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/build/include/linux/
%{__install} -m 0644 aux_pak/drivers/base/mod_devicetable_auxiliary.h \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/build/include/linux/mod_devicetable_auxiliary.h
%{__install} -m 0644 aux_pak/include/linux/auxiliary_bus.h \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/build/include/linux/auxiliary_bus.h

# rpm will complain about these files generated by depmod
rm -f ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/modules.*

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf $RPM_BUILD_ROOT

# -----------------------------------------------------------------------------

%post -n %{binary_name}
/sbin/depmod -a %{kernel}
if [ "$(uname -r)" = "%{kernel}" ]; then
    if [ -x /etc/hotplug/pci.rc ]; then
        /etc/hotplug/pci.rc start >/dev/null
    fi
    modprobe auxiliary
fi
udevadm control --reload
true

%postun -n %{binary_name}
/sbin/depmod -a %{kernel}
true

# -----------------------------------------------------------------------------

%files -n %{binary_name}
%defattr(-,root,root,-)

/lib/modules/%{kernel}/*/*
